<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Generates OverView Summary NavBar -->
	<xsl:template name="OverViewNavBar">
		<xsl:param name="header" />
	
		<!-- Main Table -->		
		<table border="0" width="100%" cellpadding="1" cellspacing="0">
		<tr>
		<td colspan="2" class="NavBarCellCommon">
		<table border="0" cellpadding="0" cellspacing="3">
		<tr align="center" valign="top">

		<!-- OverView -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gOverview"></xsl:with-param>
			<xsl:with-param name="bold" select="'true'"></xsl:with-param>
		</xsl:call-template>

		<!-- Package -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gPackage"></xsl:with-param>
		</xsl:call-template>

		<!-- Class -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gClass"></xsl:with-param>
		</xsl:call-template>

		<!-- Use -->
		<xsl:if test="$use_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gUse"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Tree -->
		<xsl:if test="$tree_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gTree"></xsl:with-param>
				<xsl:with-param name="link" select="'overview-tree.html'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Index - ALL -->
		<xsl:if test="$index_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gIndex"></xsl:with-param>
				<xsl:with-param name="link" select="'index-all.html'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Help -->
		<xsl:if test="$help_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gHelp"></xsl:with-param>
				<xsl:with-param name="link" select="'help-doc.html'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		</tr>
		</table>
		<!-- End of Main Table-->
		
		<xsl:call-template name="header_footer">
			<xsl:with-param name="header" select="$header"></xsl:with-param>
		</xsl:call-template>
		
		</td>
		</tr>
		
		<!-- Second Row Items -->
		<tr>
		
		<!-- Prev Next items-->
		<td class="NavBarCellPrevNext">
		<font size="-2">
			<xsl:value-of select="$gPrev"></xsl:value-of>
			<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
			<xsl:value-of select="$gNext"></xsl:value-of>
		</font>
		</td>

		<xsl:call-template name="Frames">
			<xsl:with-param name="ref" select="'overview-summary.html'"></xsl:with-param>
		</xsl:call-template>
		</tr>

		</table>
	
	</xsl:template>
</xsl:stylesheet>
